#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Contour lines gradientMod01.fsh  by   OzoneOnYou   
//https://www.shadertoy.com/view/csyfzG
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

float wave(float x, float y, float k) 
{
    return sin(10.0*x+10.0*y) / 5.0 +
           sin(20.0*x*k+15.0*y*k) / 3.0 +
           sin(4.0*x+10.0*y) / -4.0 +
           sin(y) / 2.0 +
           sin(x*x*y*20.0*k) + 
           sin(x * 20.0*k + 4.0) / 5.0 +
           sin(y * 30.0*k) / 5.0 + 
    	   sin(x) / 4.0;
}


//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    const vec3 col1 = vec3(0.8, 0.1, 0.5);
    const vec3 col2 = vec3(0.1, 0.1, 0.8);
    
    // Normalized pixel coordinates (from 0 to 1)
    vec2 uv = fragCoord/iResolution.xy;
    uv.xy *= 2.;
    uv.x += cos(iTime/100.)/4. - 0.5;
    uv.y += sin(iTime/100.)*2. -0.5;
    
    
    float z = wave(uv.x, uv.y, 1./10.) + 2.0;
    
    
    z *= 2.0 * (sin(iTime/20.)+2.);
    float d = fract(z);
    if(mod(z, 2.0) > 1.) d = 1.-d;
     
    vec3 col;
    for(float i=0.; i<3.; i++){
        col += vec3(step(d/fwidth(z*3.), 0.5+(iResolution.x+iResolution.y)/2000. - (i+1.)/3.)*((i+1.)/2.));
    }
    
    
    col *= mix(col1, col2, fwidth(z*4.)+0.3);
    fragColor = vec4(col, 1.);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

